/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class EmielTheBlessedEffect
extends OneShotEffect {
    EmielTheBlessedEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a +1/+1 counter on it. If it's a Unicorn, put two +1/+1 counters on it instead.";
    }

    private EmielTheBlessedEffect(EmielTheBlessedEffect effect) {
        super((OneShotEffect)effect);
    }

    public EmielTheBlessedEffect copy() {
        return new EmielTheBlessedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        int counters = permanent.hasSubtype(SubType.UNICORN, game) ? 2 : 1;
        return permanent.addCounters(CounterType.P1P1.createInstance(counters), source.getControllerId(), source, game);
    }
}

