/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInExile;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class EmperorOfBonesEffect
extends OneShotEffect {
    EmperorOfBonesEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "put a creature card exiled with {this} onto the battlefield under your control with a finality counter on it. It gains haste. Sacrifice it at the beginning of the next end step";
    }

    private EmperorOfBonesEffect(EmperorOfBonesEffect effect) {
        super((OneShotEffect)effect);
    }

    public EmperorOfBonesEffect copy() {
        return new EmperorOfBonesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInExile target = new TargetCardInExile(1, 1, (FilterCard)StaticFilters.FILTER_CARD_CREATURE, CardUtil.getExileZoneId((Game)game, (Ability)source));
        player.choose(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return true;
        }
        game.setEnterWithCounters(card.getId(), new Counters(new Counter[0]).addCounter(CounterType.FINALITY.createInstance()));
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return true;
        }
        game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfGame).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new SacrificeTargetEffect("sacrifice it").setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), TargetController.ANY), source);
        return true;
    }
}

