/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.game.Game;
import mage.players.Player;

class EmptyTheCatacombsEffect
extends OneShotEffect {
    private static final FilterCreatureCard filter = new FilterCreatureCard("creature");

    public EmptyTheCatacombsEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Each player returns all creature cards from their graveyard to their hand";
    }

    private EmptyTheCatacombsEffect(EmptyTheCatacombsEffect effect) {
        super((OneShotEffect)effect);
    }

    public EmptyTheCatacombsEffect copy() {
        return new EmptyTheCatacombsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashSet<Card> toHand = new HashSet<Card>();
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                for (Card card : player.getGraveyard().getCards((FilterCard)filter, game)) {
                    if (card == null) continue;
                    toHand.add(card);
                }
            }
            controller.moveCards(toHand, Zone.HAND, source, game, false, false, true, null);
            return true;
        }
        return false;
    }
}

