/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;
import mage.util.CardUtil;

class EmptyTheLaboratoryEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.ZOMBIE, "Zombies");
    private static final FilterCard filter2 = new FilterCreatureCard();

    EmptyTheLaboratoryEffect() {
        super(Outcome.Benefit);
        this.staticText = "sacrifice X Zombies, then reveal cards from the top of your library until you reveal a number of Zombie creature cards equal to the number of Zombies sacrificed this way. Put those cards onto the battlefield and the rest on the bottom of your library in a random order";
    }

    private EmptyTheLaboratoryEffect(EmptyTheLaboratoryEffect effect) {
        super((OneShotEffect)effect);
    }

    public EmptyTheLaboratoryEffect copy() {
        return new EmptyTheLaboratoryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int toSacrifice = Math.min((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0), game.getBattlefield().count(filter, source.getControllerId(), source, game));
        if (toSacrifice < 1) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice(toSacrifice, filter);
        player.choose(Outcome.Sacrifice, (Target)target, source, game);
        int sacrificed = 0;
        for (UUID permanentId : target.getTargets()) {
            Permanent permanent = game.getPermanent(permanentId);
            if (permanent == null || !permanent.sacrifice(source, game)) continue;
            ++sacrificed;
        }
        game.processAction();
        CardsImpl toReveal = new CardsImpl();
        int zombies = 0;
        for (Card card : player.getLibrary().getCards(game)) {
            toReveal.add(card);
            if (card.isCreature(game) && card.hasSubtype(SubType.ZOMBIE, game)) {
                ++zombies;
            }
            if (zombies < sacrificed) continue;
            break;
        }
        player.revealCards(source, (Cards)toReveal, game);
        player.moveCards(toReveal.getCards(filter2, game), Zone.BATTLEFIELD, source, game);
        toReveal.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)toReveal, game, source, false);
        return true;
    }

    static {
        filter2.add((Predicate)SubType.ZOMBIE.getPredicate());
    }
}

