/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class EmrakulsEvangelCost
extends CostImpl {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("non-Eldrazi creatures you control");
    private int numSacrificed = 1;

    public EmrakulsEvangelCost() {
        this.text = "Sacrifice {this} and any number of other non-Eldrazi creatures";
    }

    private EmrakulsEvangelCost(EmrakulsEvangelCost cost) {
        super((CostImpl)cost);
        this.numSacrificed = cost.getNumSacrificed();
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Permanent selfPermanent = game.getPermanent(source.getSourceId());
        Player player = game.getPlayer(controllerId);
        if (selfPermanent != null && player != null) {
            this.paid = selfPermanent.sacrifice(source, game);
            TargetSacrifice target = new TargetSacrifice(0, Integer.MAX_VALUE, (FilterPermanent)filter);
            player.choose(Outcome.Sacrifice, (Target)target, ability, game);
            for (UUID permanentId : target.getTargets()) {
                Permanent otherPermanent = game.getPermanent(permanentId);
                if (otherPermanent == null || !otherPermanent.sacrifice(source, game)) continue;
                ++this.numSacrificed;
            }
        }
        return this.paid;
    }

    public int getNumSacrificed() {
        return this.numSacrificed;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        return permanent != null && game.getPlayer(controllerId).canPaySacrificeCost(permanent, source, controllerId, game);
    }

    public EmrakulsEvangelCost copy() {
        return new EmrakulsEvangelCost(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        filter.add(Predicates.not((Predicate)SubType.ELDRAZI.getPredicate()));
    }
}

