/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

public final class EnchantedEvening
extends CardImpl {
    public EnchantedEvening(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{3}{W/U}{W/U}");
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new EnchangedEveningEffect()));
    }

    private EnchantedEvening(EnchantedEvening card) {
        super((CardImpl)card);
    }

    public EnchantedEvening copy() {
        return new EnchantedEvening(this);
    }

    private static class EnchangedEveningEffect
    extends ContinuousEffectImpl {
        private EnchangedEveningEffect() {
            super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
            this.dependencyTypes.add(DependencyType.EnchantmentAddingRemoving);
            this.dependencyTypes.add(DependencyType.AuraAddingRemoving);
            this.staticText = "All permanents are enchantments in addition to their other types";
        }

        private EnchangedEveningEffect(EnchangedEveningEffect effect) {
            super((ContinuousEffectImpl)effect);
        }

        public boolean apply(Game game, Ability source) {
            for (Permanent permanent : game.getBattlefield().getActivePermanents(StaticFilters.FILTER_PERMANENT, source.getControllerId(), source, game)) {
                if (permanent == null) continue;
                permanent.addCardType(game, new CardType[]{CardType.ENCHANTMENT});
            }
            return true;
        }

        public EnchangedEveningEffect copy() {
            return new EnchangedEveningEffect(this);
        }
    }
}

