/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class EnchantersBaneEffect
extends OneShotEffect {
    EnchantersBaneEffect() {
        super(Outcome.Benefit);
        this.staticText = "target enchantment deals damage equal to its mana value to its controller unless that player sacrifices it";
    }

    private EnchantersBaneEffect(EnchantersBaneEffect effect) {
        super((OneShotEffect)effect);
    }

    public EnchantersBaneEffect copy() {
        return new EnchantersBaneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        Player player = game.getPlayer(permanent.getControllerId());
        if (player == null) {
            return false;
        }
        if (player.chooseUse(Outcome.GainLife, "Sacrifice " + permanent.getLogName() + "?", source, game)) {
            permanent.sacrifice(source, game);
        } else {
            player.damage(permanent.getManaValue(), permanent.getId(), source, game);
        }
        return true;
    }
}

