/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyAllEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.SharesCreatureTypePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class EndemicPlagueEffect
extends OneShotEffect {
    EndemicPlagueEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "destroy all creatures that share a creature type with the sacrificed creature. They can't be regenerated";
    }

    private EndemicPlagueEffect(EndemicPlagueEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent permanent = null;
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof SacrificeTargetCost) || ((SacrificeTargetCost)cost).getPermanents().isEmpty()) continue;
            permanent = (Permanent)((SacrificeTargetCost)cost).getPermanents().get(0);
            break;
        }
        if (permanent == null) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add((Predicate)new SharesCreatureTypePredicate(permanent));
        return new DestroyAllEffect((FilterPermanent)filter, true).apply(game, source);
    }

    public EndemicPlagueEffect copy() {
        return new EndemicPlagueEffect(this);
    }
}

