/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ReturnToHandSourceEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class EndlessEvilBounceAbility
extends TriggeredAbilityImpl {
    public EndlessEvilBounceAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ReturnToHandSourceEffect(false, true));
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private EndlessEvilBounceAbility(EndlessEvilBounceAbility effect) {
        super((TriggeredAbilityImpl)effect);
    }

    public EndlessEvilBounceAbility copy() {
        return new EndlessEvilBounceAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (((ZoneChangeEvent)event).isDiesEvent()) {
            Permanent permanent = (Permanent)game.getLastKnownInformation(event.getTargetId(), Zone.BATTLEFIELD);
            return permanent.getAttachments().contains(this.getSourceId()) && permanent.hasSubtype(SubType.HORROR, game);
        }
        return false;
    }

    public String getRule() {
        return "When enchanted creature dies, if that creature was a Horror, return {this} to its owner's hand.";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

