/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class EndlessHorizonsEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("Plains card");

    EndlessHorizonsEffect() {
        super(Outcome.Neutral);
        this.staticText = "search your library for any number of Plains cards, exile them, then shuffle";
    }

    private EndlessHorizonsEffect(EndlessHorizonsEffect effect) {
        super((OneShotEffect)effect);
    }

    public EndlessHorizonsEffect copy() {
        return new EndlessHorizonsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(0, Integer.MAX_VALUE, filter);
        player.searchLibrary(target, source, game);
        CardsImpl cards = new CardsImpl();
        target.getTargets().stream().map(uuid -> player.getLibrary().getCard(uuid, game)).filter(Objects::nonNull).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        player.moveCardsToExile(cards.getCards(game), source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        player.shuffleLibrary(source, game);
        return true;
    }

    static {
        filter.add((Predicate)SubType.PLAINS.getPredicate());
    }
}

