/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class EnduringIdealEffect
extends OneShotEffect {
    EnduringIdealEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search your library for an enchantment card, put it onto the battlefield, then shuffle";
    }

    private EnduringIdealEffect(EnduringIdealEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        boolean applied = false;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            TargetCardInLibrary target = new TargetCardInLibrary(StaticFilters.FILTER_CARD_ENCHANTMENT);
            controller.searchLibrary(target, source, game);
            Card targetCard = game.getCard(target.getFirstTarget());
            if (targetCard == null) {
                applied = false;
            } else {
                applied = controller.moveCards(targetCard, Zone.BATTLEFIELD, source, game);
                controller.shuffleLibrary(source, game);
            }
        }
        return applied;
    }

    public EnduringIdealEffect copy() {
        return new EnduringIdealEffect(this);
    }
}

