/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class EnduringScalelordTriggeredAbility
extends TriggeredAbilityImpl {
    EnduringScalelordTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance()), true);
    }

    private EnduringScalelordTriggeredAbility(EnduringScalelordTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public EnduringScalelordTriggeredAbility copy() {
        return new EnduringScalelordTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getData().equals(CounterType.P1P1.getName())) {
            Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
            if (permanent == null) {
                permanent = game.getPermanentEntering(event.getTargetId());
            }
            return permanent != null && !event.getTargetId().equals(this.getSourceId()) && permanent.isCreature(game) && permanent.isControlledBy(this.getControllerId());
        }
        return false;
    }

    public String getRule() {
        return "Whenever one or more +1/+1 counters are put on another creature you control, you may put a +1/+1 counter on {this}.";
    }
}

