/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class EnslaveEffect
extends OneShotEffect {
    EnslaveEffect() {
        super(Outcome.Damage);
        this.staticText = "enchanted creature deals 1 damage to its owner";
    }

    private EnslaveEffect(EnslaveEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player owner;
        Permanent attached;
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (sourcePermanent != null && (attached = game.getPermanentOrLKIBattlefield(sourcePermanent.getAttachedTo())) != null && (owner = game.getPlayer(attached.getOwnerId())) != null) {
            owner.damage(1, attached.getId(), source, game);
            return true;
        }
        return false;
    }

    public EnslaveEffect copy() {
        return new EnslaveEffect(this);
    }
}

