/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.AmassEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class EnterTheGodEternalsEffect
extends OneShotEffect {
    EnterTheGodEternalsEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 4 damage to target creature and you gain life equal to the damage dealt this way. Target player mills four cards. Amass Zombies 4.";
    }

    private EnterTheGodEternalsEffect(EnterTheGodEternalsEffect effect) {
        super((OneShotEffect)effect);
    }

    public EnterTheGodEternalsEffect copy() {
        return new EnterTheGodEternalsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (Target target : source.getTargets()) {
            for (UUID targetId : target.getTargets()) {
                Permanent permanent = game.getPermanent(targetId);
                if (permanent != null) {
                    controller.gainLife(permanent.damage(4, source.getSourceId(), source, game), game, source);
                    continue;
                }
                Player player = game.getPlayer(targetId);
                if (player == null) continue;
                player.millCards(4, source, game);
            }
        }
        return new AmassEffect(4, SubType.ZOMBIE).apply(game, source);
    }
}

