/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetDiscard;

class EntropicBattlecruiserEffect
extends OneShotEffect {
    EntropicBattlecruiserEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent discards a card. Each opponent who doesn't loses 3 life";
    }

    private EntropicBattlecruiserEffect(EntropicBattlecruiserEffect effect) {
        super((OneShotEffect)effect);
    }

    public EntropicBattlecruiserEffect copy() {
        return new EntropicBattlecruiserEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        HashMap<UUID, Card> map = new HashMap<UUID, Card>();
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            player = game.getPlayer(opponentId);
            if (player == null || player.getHand().isEmpty()) continue;
            TargetDiscard target = new TargetDiscard(opponentId);
            player.choose(Outcome.Discard, (Target)target, source, game);
            map.put(opponentId, game.getCard(target.getFirstTarget()));
        }
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            player = game.getPlayer(opponentId);
            if (player == null || player.discard((Card)map.getOrDefault(opponentId, null), false, source, game)) continue;
            player.loseLife(3, game, source, false);
        }
        return true;
    }
}

