/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.keyword.ProtectionAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class EowynFearlessKnightEffect
extends OneShotEffect {
    EowynFearlessKnightEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target creature an opponent controls with greater power. Legendary creatures you control gain protection from each of that creature's colors until end of turn";
    }

    private EowynFearlessKnightEffect(EowynFearlessKnightEffect effect) {
        super((OneShotEffect)effect);
    }

    public EowynFearlessKnightEffect copy() {
        return new EowynFearlessKnightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null) {
            return false;
        }
        player.moveCards((Card)permanent, Zone.EXILED, source, game);
        for (ObjectColor color : permanent.getColor(game).getColors()) {
            game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)ProtectionAbility.from((ObjectColor)color), Duration.EndOfTurn, (FilterPermanent)StaticFilters.FILTER_CREATURE_LEGENDARY), source);
        }
        return true;
    }
}

