/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ErraticMutationEffect
extends OneShotEffect {
    ErraticMutationEffect() {
        super(Outcome.UnboostCreature);
        this.staticText = "Choose target creature. Reveal cards from the top of your library until you reveal a nonland card. That creature gets +X/-X until end of turn, where X is that card's mana value. Put all cards revealed this way on the bottom of your library in any order";
    }

    private ErraticMutationEffect(ErraticMutationEffect effect) {
        super((OneShotEffect)effect);
    }

    public ErraticMutationEffect copy() {
        return new ErraticMutationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null) {
            CardsImpl toReveal = new CardsImpl();
            Card nonLandCard = null;
            for (Card card : controller.getLibrary().getCards(game)) {
                toReveal.add(card);
                if (card.isLand(game)) continue;
                nonLandCard = card;
                break;
            }
            controller.revealCards(sourceObject.getIdName(), (Cards)toReveal, game);
            if (nonLandCard != null) {
                int boostValue = nonLandCard.getManaValue();
                BoostTargetEffect effect = new BoostTargetEffect(boostValue, -boostValue, Duration.EndOfTurn);
                effect.setTargetPointer((TargetPointer)new FixedTarget(this.getTargetPointer().getFirst(game, source), game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return controller.putCardsOnBottomOfLibrary((Cards)toReveal, game, source, true);
        }
        return false;
    }
}

