/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Collection;
import java.util.Objects;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.ProtectionAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class EscapedShapeshifterEffect
extends ContinuousEffectImpl {
    EscapedShapeshifterEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.addDependedToType(DependencyType.AddingAbility);
        this.staticText = "As long as an opponent controls a creature with flying not named Escaped Shapeshifter, {this} has flying. The same is true for first strike, trample, and protection from any color.";
    }

    private EscapedShapeshifterEffect(EscapedShapeshifterEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent == null) {
            return false;
        }
        game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_OPPONENTS_PERMANENT_CREATURE, source.getControllerId(), source, game).stream().filter(Objects::nonNull).filter(permanent -> !permanent.getName().equals("Escaped Shapeshifter")).map(MageObject::getAbilities).flatMap(Collection::stream).filter(EscapedShapeshifterEffect::checkAbility).forEach(ability -> sourcePermanent.addAbility(ability, source.getSourceId(), game));
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkAbility(Ability ability) {
        if (ability instanceof FlyingAbility) return true;
        if (ability instanceof FirstStrikeAbility) return true;
        if (ability instanceof TrampleAbility) {
            return true;
        }
        if (!(ability instanceof ProtectionAbility)) return false;
        if (!((ProtectionAbility)ability).getFilter().getPredicates().stream().anyMatch(ColorPredicate.class::isInstance)) return false;
        return true;
    }

    public EscapedShapeshifterEffect copy() {
        return new EscapedShapeshifterEffect(this);
    }
}

