/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.RemoveAllCountersSourceCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class EssenceBottleEffect
extends OneShotEffect {
    EssenceBottleEffect() {
        super(Outcome.GainLife);
        this.staticText = "You gain 2 life for each elixir counter removed this way";
    }

    private EssenceBottleEffect(EssenceBottleEffect effect) {
        super((OneShotEffect)effect);
    }

    public EssenceBottleEffect copy() {
        return new EssenceBottleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int countersRemoved = 0;
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof RemoveAllCountersSourceCost)) continue;
            countersRemoved = ((RemoveAllCountersSourceCost)cost).getRemovedCounters();
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            player.gainLife(countersRemoved * 2, game, source);
            return true;
        }
        return false;
    }
}

