/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class EssenceOfTheWildEffect
extends ReplacementEffectImpl {
    EssenceOfTheWildEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Copy, false);
        this.staticText = "Creatures you control enter the battlefield as a copy of {this}";
    }

    private EssenceOfTheWildEffect(EssenceOfTheWildEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent perm = ((EntersTheBattlefieldEvent)event).getTarget();
        return perm != null && perm.isCreature(game) && perm.isControlledBy(source.getControllerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent sourceObject = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (sourceObject != null) {
            game.copyPermanent(sourceObject, event.getTargetId(), source, null);
        }
        return false;
    }

    public EssenceOfTheWildEffect copy() {
        return new EssenceOfTheWildEffect(this);
    }
}

