/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.MillCardsControllerEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterEnchantmentCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;

class EstridTheMaskedGraveyardEffect
extends OneShotEffect {
    private static final FilterEnchantmentCard filter = new FilterEnchantmentCard();
    private static final FilterEnchantmentCard filter2 = new FilterEnchantmentCard();

    public EstridTheMaskedGraveyardEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "mill seven cards. Return all non-Aura enchantment cards from your graveyard to the battlefield, then do the same for Aura cards";
    }

    private EstridTheMaskedGraveyardEffect(EstridTheMaskedGraveyardEffect effect) {
        super((OneShotEffect)effect);
    }

    public EstridTheMaskedGraveyardEffect copy() {
        return new EstridTheMaskedGraveyardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        new MillCardsControllerEffect(7).apply(game, source);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        controller.moveCards(controller.getGraveyard().getCards((FilterCard)filter, source.getControllerId(), source, game), Zone.BATTLEFIELD, source, game);
        controller.moveCards(controller.getGraveyard().getCards((FilterCard)filter2, source.getControllerId(), source, game), Zone.BATTLEFIELD, source, game);
        return true;
    }

    static {
        filter.add(Predicates.not((Predicate)SubType.AURA.getPredicate()));
        filter2.add((Predicate)SubType.AURA.getPredicate());
    }
}

