/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class EstridsInvocationEffect
extends OneShotEffect {
    EstridsInvocationEffect() {
        super(Outcome.Neutral);
        this.staticText = "exile this enchantment. If you do, return it to the battlefield under its owner's control";
    }

    private EstridsInvocationEffect(EstridsInvocationEffect effect) {
        super((OneShotEffect)effect);
    }

    public EstridsInvocationEffect copy() {
        return new EstridsInvocationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || player == null) {
            return false;
        }
        Card card = permanent.getMainCard();
        player.moveCards((Card)permanent, Zone.EXILED, source, game);
        player.moveCards(card, Zone.BATTLEFIELD, source, game, false, false, true, null);
        return true;
    }
}

