/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class EtaliPrimalConquerorEffect
extends OneShotEffect {
    EtaliPrimalConquerorEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player exiles cards from the top of their library until they exile a nonland card. You may cast any number of spells from among the nonland cards exiled this way without paying their mana costs";
    }

    private EtaliPrimalConquerorEffect(EtaliPrimalConquerorEffect effect) {
        super((OneShotEffect)effect);
    }

    public EtaliPrimalConquerorEffect copy() {
        return new EtaliPrimalConquerorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        block0: for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            for (Card card : player.getLibrary().getCards(game)) {
                player.moveCards(card, Zone.EXILED, source, game);
                if (card.isLand(game)) continue;
                cards.add(card);
                continue block0;
            }
        }
        game.processAction();
        cards.retainZone(Zone.EXILED, game);
        CardUtil.castMultipleWithAttributeForFree((Player)controller, (Ability)source, (Game)game, (Cards)cards, (FilterCard)StaticFilters.FILTER_CARD);
        return true;
    }
}

