/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterNonlandCard;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class EtaliPrimalStormEffect
extends OneShotEffect {
    private static final FilterNonlandCard filter = new FilterNonlandCard("nonland cards");

    public EtaliPrimalStormEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "exile the top card of each player's library, then you may cast any number of spells from among those cards without paying their mana costs";
    }

    private EtaliPrimalStormEffect(EtaliPrimalStormEffect effect) {
        super((OneShotEffect)effect);
    }

    public EtaliPrimalStormEffect copy() {
        return new EtaliPrimalStormEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            cards.add(player.getLibrary().getFromTop(game));
        }
        controller.moveCards((Cards)cards, Zone.EXILED, source, game);
        game.processAction();
        cards.retainZone(Zone.EXILED, game);
        CardUtil.castMultipleWithAttributeForFree((Player)controller, (Ability)source, (Game)game, (Cards)cards, (FilterCard)filter);
        return true;
    }
}

