/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.WhiteBlackSpiritToken;
import mage.players.Player;

class EtherealAbsolutionEffect
extends OneShotEffect {
    EtherealAbsolutionEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile target card from an opponent's graveyard. If it was a creature card, you create a 1/1 white and black Spirit creature token with flying.";
    }

    private EtherealAbsolutionEffect(EtherealAbsolutionEffect effect) {
        super((OneShotEffect)effect);
    }

    public EtherealAbsolutionEffect copy() {
        return new EtherealAbsolutionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (player == null || card == null) {
            return false;
        }
        if (card.isCreature(game)) {
            new CreateTokenEffect((Token)new WhiteBlackSpiritToken()).apply(game, source);
        }
        return player.moveCards(card, Zone.EXILED, source, game);
    }
}

