/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInExile;
import mage.util.CardUtil;

class EtherealForagerEffect
extends OneShotEffect {
    EtherealForagerEffect() {
        super(Outcome.Benefit);
        this.staticText = "return an instant or sorcery card exiled with {this} to its owner's hand";
    }

    private EtherealForagerEffect(EtherealForagerEffect effect) {
        super((OneShotEffect)effect);
    }

    public EtherealForagerEffect copy() {
        return new EtherealForagerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        String keyString = CardUtil.getCardZoneString((String)"delvedCards", (UUID)source.getSourceId(), (Game)game, (boolean)true);
        Cards delvedCards = (Cards)game.getState().getValue(keyString);
        if (delvedCards == null || delvedCards.count((FilterCard)StaticFilters.FILTER_CARD_INSTANT_AND_SORCERY, game) < 1) {
            return false;
        }
        TargetCardInExile targetCard = new TargetCardInExile(0, 1, (FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY);
        player.choose(Outcome.DrawCard, delvedCards, (TargetCard)targetCard, source, game);
        Card card = game.getCard(targetCard.getFirstTarget());
        if (card == null || !player.moveCards(card, Zone.HAND, source, game)) {
            return false;
        }
        delvedCards.remove(card);
        return true;
    }
}

