/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.CanBeSacrificedPredicate;
import mage.game.Game;
import mage.game.Ownerable;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;
import mage.target.common.TargetDiscard;

class EumidianWastewakerEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent();

    EumidianWastewakerEffect() {
        super(Outcome.Benefit);
        this.staticText = "you and defending player each discard a card or sacrifice a permanent. You draw a card for each land card put into a graveyard this way";
    }

    private EumidianWastewakerEffect(EumidianWastewakerEffect effect) {
        super((OneShotEffect)effect);
    }

    public EumidianWastewakerEffect copy() {
        return new EumidianWastewakerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player defendingPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null) {
            return false;
        }
        HashSet<Permanent> toSacrifice = new HashSet<Permanent>();
        HashSet<Card> toDiscard = new HashSet<Card>();
        for (Player player2 : Arrays.asList(controller, defendingPlayer)) {
            if (player2 == null) continue;
            boolean canDiscard = !player2.getHand().isEmpty();
            boolean canSacrifice = game.getBattlefield().contains((FilterPermanent)filter, player2.getId(), source, game, 1);
            if (canSacrifice && !canDiscard) {
                EumidianWastewakerEffect.chooseSacrifice(player2, toSacrifice, game, source);
                continue;
            }
            if (!canSacrifice && canDiscard) {
                EumidianWastewakerEffect.chooseDiscard(player2, toDiscard, game, source);
                continue;
            }
            if (!canSacrifice && !canSacrifice) continue;
            if (player2.chooseUse(Outcome.Sacrifice, "Sacrifice a permanent or discard a card?", null, "Sacrifice", "Discard", source, game)) {
                EumidianWastewakerEffect.chooseSacrifice(player2, toSacrifice, game, source);
                continue;
            }
            EumidianWastewakerEffect.chooseDiscard(player2, toDiscard, game, source);
        }
        toSacrifice.removeIf(Objects::isNull);
        toDiscard.removeIf(Objects::isNull);
        HashSet<UUID> lands = new HashSet<UUID>();
        for (Permanent permanent : toSacrifice) {
            permanent.sacrifice(source, game);
            Card card = permanent.getMainCard();
            if (card == null || !card.isLand(game) || !Zone.GRAVEYARD.match(game.getState().getZone(card.getId()))) continue;
            lands.add(card.getId());
        }
        for (Card card : toDiscard) {
            Optional.ofNullable(card).map(Ownerable::getOwnerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).map(player -> player.discard(card, false, source, game));
            if (!card.isLand(game) || !Zone.GRAVEYARD.match(game.getState().getZone(card.getId()))) continue;
            lands.add(card.getId());
        }
        Optional.of(lands).map(Set::size).filter(x -> x > 0).ifPresent(x -> controller.drawCards(x.intValue(), source, game));
        return true;
    }

    static void chooseSacrifice(Player player, Set<Permanent> toSacrifice, Game game, Ability source) {
        TargetControlledPermanent target = new TargetControlledPermanent(filter);
        target.withChooseHint("to sacrifice");
        target.withNotTarget(true);
        player.choose(Outcome.Sacrifice, (Target)target, source, game);
        toSacrifice.add(game.getPermanent(target.getFirstTarget()));
    }

    static void chooseDiscard(Player player, Set<Card> toDiscard, Game game, Ability source) {
        TargetDiscard target = new TargetDiscard(player.getId());
        player.choose(Outcome.Discard, (Target)target, source, game);
        toDiscard.add(game.getCard(target.getFirstTarget()));
    }

    static {
        filter.add((Predicate)CanBeSacrificedPredicate.instance);
    }
}

