/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.game.Game;
import mage.players.Player;
import mage.players.PlayerList;
import mage.target.common.TargetCardInHand;

class EurekaEffect
extends OneShotEffect {
    EurekaEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Starting with you, each player may put a permanent card from their hand onto the battlefield. Repeat this process until no one puts a card onto the battlefield";
    }

    private EurekaEffect(EurekaEffect effect) {
        super((OneShotEffect)effect);
    }

    public EurekaEffect copy() {
        return new EurekaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            PlayerList playerList = game.getState().getPlayerList().copy();
            while (!((UUID)playerList.get()).equals(source.getControllerId()) && controller.canRespond()) {
                playerList.getNext();
            }
            Player currentPlayer = game.getPlayer((UUID)playerList.get());
            UUID firstInactivePlayer = null;
            TargetCardInHand target = new TargetCardInHand((FilterCard)new FilterPermanentCard());
            while (controller.canRespond()) {
                if (firstInactivePlayer == null) {
                    firstInactivePlayer = currentPlayer.getId();
                }
                if (currentPlayer != null && currentPlayer.canRespond() && game.getState().getPlayersInRange(controller.getId(), game).contains((Object)currentPlayer.getId())) {
                    Card card;
                    target.clearChosen();
                    if (target.canChoose(currentPlayer.getId(), source, game) && currentPlayer.chooseUse(this.outcome, "Put permanent from your hand to play?", source, game) && target.chooseTarget(this.outcome, currentPlayer.getId(), source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
                        currentPlayer.moveCards(card, Zone.BATTLEFIELD, source, game);
                        firstInactivePlayer = null;
                    }
                }
                playerList.getNext();
                currentPlayer = game.getPlayer((UUID)playerList.get());
                if (currentPlayer == null || !currentPlayer.getId().equals(firstInactivePlayer)) continue;
            }
            return true;
        }
        return false;
    }
}

