/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.e.EvelynTheCovetousWatcher;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class EvelynTheCovetousExileEffect
extends OneShotEffect {
    EvelynTheCovetousExileEffect() {
        super(Outcome.Exile);
        this.staticText = "exile the top card of each player's library with a collection counter on it";
    }

    private EvelynTheCovetousExileEffect(EvelynTheCovetousExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public EvelynTheCovetousExileEffect copy() {
        return new EvelynTheCovetousExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            cards.add(player.getLibrary().getFromTop(game));
        }
        if (cards.isEmpty()) {
            return false;
        }
        controller.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.getCards(game).stream().forEach(card -> card.addCounters(CounterType.COLLECTION.createInstance(), source, game));
        EvelynTheCovetousWatcher.addCards(source.getControllerId(), (Cards)cards, game);
        return true;
    }
}

