/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.PermanentToken;
import mage.util.CardUtil;
import mage.watchers.common.PermanentsSacrificedWatcher;

class EvendoBrushrazerEffect
extends AsThoughEffectImpl {
    EvendoBrushrazerEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "during your turn, as long as you've sacrificed a nontoken permanent this turn, you may play cards exiled with this creature";
    }

    private EvendoBrushrazerEffect(EvendoBrushrazerEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public EvendoBrushrazerEffect copy() {
        return new EvendoBrushrazerEffect(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (!source.isControlledBy(affectedControllerId)) return false;
        if (!game.isActivePlayer(affectedControllerId)) return false;
        if (((PermanentsSacrificedWatcher)game.getState().getWatcher(PermanentsSacrificedWatcher.class)).getThisTurnSacrificedPermanents(affectedControllerId).stream().allMatch(PermanentToken.class::isInstance)) return false;
        if (!game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)game.getState().getZoneChangeCounter(source.getSourceId()))).contains((Object)CardUtil.getMainCardId((Game)game, (UUID)objectId))) return false;
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }
}

