/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.AuraCardCanAttachToPermanentId;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

class EvershrikeEffect
extends OneShotEffect {
    EvershrikeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Return {this} from your graveyard to the battlefield. You may put an Aura card with mana value X or less from your hand onto the battlefield attached to it. If you don't, exile {this}";
    }

    private EvershrikeEffect(EvershrikeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Card evershrikeCard = game.getCard(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || evershrikeCard == null) {
            return false;
        }
        int xAmount = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        controller.moveCards(evershrikeCard, Zone.BATTLEFIELD, source, game);
        Permanent evershrikePermanent = game.getPermanent(evershrikeCard.getId());
        if (evershrikePermanent == null) {
            if (game.getState().getZone(evershrikeCard.getId()) != Zone.EXILED) {
                controller.moveCards(evershrikeCard, Zone.EXILED, source, game);
            }
            return false;
        }
        boolean exileSource = true;
        FilterCard filterAuraCard = new FilterCard("Aura card with mana value X or less from your hand");
        filterAuraCard.add((Predicate)CardType.ENCHANTMENT.getPredicate());
        filterAuraCard.add((Predicate)SubType.AURA.getPredicate());
        filterAuraCard.add((Predicate)new AuraCardCanAttachToPermanentId(evershrikePermanent.getId()));
        filterAuraCard.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, xAmount + 1));
        int count = controller.getHand().count(filterAuraCard, game);
        if (count > 0 && controller.chooseUse(Outcome.Benefit, "Put an Aura card from your hand onto the battlefield attached to " + evershrikeCard.getIdName() + "?", source, game)) {
            Card aura;
            TargetCard targetAura = new TargetCard(Zone.HAND, filterAuraCard);
            if (controller.choose(Outcome.Benefit, controller.getHand(), targetAura, source, game) && (aura = game.getCard(targetAura.getFirstTarget())) != null) {
                game.getState().setValue("attachTo:" + aura.getId(), (Object)evershrikePermanent);
                if (controller.moveCards(aura, Zone.BATTLEFIELD, source, game)) {
                    evershrikePermanent.addAttachment(aura.getId(), source, game);
                }
                exileSource = false;
            }
        }
        if (exileSource) {
            controller.moveCards(evershrikeCard, Zone.EXILED, source, game);
        }
        return true;
    }

    public EvershrikeEffect copy() {
        return new EvershrikeEffect(this);
    }
}

