/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.HexproofAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.players.Player;

class EverybodyLivesPlayerEffect
extends ContinuousEffectImpl {
    EverybodyLivesPlayerEffect() {
        super(Duration.EndOfTurn, Layer.PlayerEffects, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Players gain hexproof until end of turn. Players can't lose life this turn";
    }

    private EverybodyLivesPlayerEffect(EverybodyLivesPlayerEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public EverybodyLivesPlayerEffect copy() {
        return new EverybodyLivesPlayerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            player.addAbility((Ability)HexproofAbility.getInstance());
            player.setCanLoseLife(false);
        }
        return true;
    }
}

