/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.CantBeBlockedTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class EvieFryeEffect
extends OneShotEffect {
    EvieFryeEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw a card, then discard a card. When you discard a creature card this way, target creature you control can't be blocked this turn";
    }

    private EvieFryeEffect(EvieFryeEffect effect) {
        super((OneShotEffect)effect);
    }

    public EvieFryeEffect copy() {
        return new EvieFryeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.drawCards(1, source, game);
        Card card = player.discardOne(false, false, source, game);
        if (card != null && card.isCreature(game)) {
            ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new CantBeBlockedTargetEffect(), false);
            ability.addTarget((Target)new TargetControlledCreaturePermanent());
            game.fireReflexiveTriggeredAbility(ability, source);
        }
        return true;
    }
}

