/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class EvolvingAdaptiveTriggeredAbility
extends TriggeredAbilityImpl {
    public EvolvingAdaptiveTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.OIL.createInstance()));
        this.setTriggerPhrase("Whenever another creature enters the battlefield under your control, if that creature has greater power or toughness than {this}, ");
    }

    private EvolvingAdaptiveTriggeredAbility(EvolvingAdaptiveTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public EvolvingAdaptiveTriggeredAbility copy() {
        return new EvolvingAdaptiveTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent enteringCreature = game.getPermanent(event.getTargetId());
        Permanent permanent = this.getSourcePermanentIfItStillExists(game);
        if (enteringCreature == null || permanent == null || !StaticFilters.FILTER_ANOTHER_CREATURE_YOU_CONTROL.match(enteringCreature, this.getControllerId(), (Ability)this, game)) {
            return false;
        }
        return enteringCreature.getPower().getValue() > permanent.getPower().getValue() || enteringCreature.getToughness().getValue() > permanent.getToughness().getValue();
    }
}

