/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class EvolvingDoorEffect
extends OneShotEffect {
    private static final Map<Integer, FilterCard> filterMap = new HashMap<Integer, FilterCard>();

    EvolvingDoorEffect() {
        super(Outcome.Benefit);
        this.staticText = "count the colors of the sacrificed creature, then search your library for a creature card that's exactly that many colors plus one. Exile that card, then shuffle. You may cast the exiled card";
    }

    private EvolvingDoorEffect(EvolvingDoorEffect effect) {
        super((OneShotEffect)effect);
    }

    public EvolvingDoorEffect copy() {
        return new EvolvingDoorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = CardUtil.castStream((Stream)source.getCosts().stream(), SacrificeTargetCost.class).filter(Objects::nonNull).map(SacrificeTargetCost::getPermanents).flatMap(Collection::stream).findFirst().orElse(null);
        if (player == null || permanent == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(filterMap.get(permanent.getColor(game).getColorCount() + 1));
        player.searchLibrary(target, source, game);
        Card card = player.getLibrary().getCard(target.getFirstTarget(), game);
        player.moveCards(card, Zone.EXILED, source, game);
        player.shuffleLibrary(source, game);
        if (card == null || !player.chooseUse(Outcome.PlayForFree, "Cast " + card.getName() + '?', source, game)) {
            return true;
        }
        game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), (Object)Boolean.TRUE);
        player.cast(player.chooseAbilityForCast(card, game, false), game, false, new ApprovingObject(source, game));
        game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
        return true;
    }

    static {
        for (int count = 1; count <= 6; ++count) {
            FilterCreatureCard filter = new FilterCreatureCard("creature card that's exactly " + CardUtil.numberToText((int)count) + " color" + (count > 0 ? "s" : ""));
            filter.add((Predicate)new EvolvingDoorPredicate(count));
            filterMap.put(count, (FilterCard)filter);
        }
    }

    private static final class EvolvingDoorPredicate
    implements Predicate<Card> {
        private final int count;

        private EvolvingDoorPredicate(int count) {
            this.count = count;
        }

        public boolean apply(Card input, Game game) {
            return input.getColor(game).getColorCount() == this.count;
        }
    }
}

