/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostControlledEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.MageObjectReferencePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ExhilaratingElocutionEffect
extends OneShotEffect {
    ExhilaratingElocutionEffect() {
        super(Outcome.Benefit);
        this.staticText = "put two +1/+1 counters on target creature you control. Other creatures you control get +1/+1 until end of turn";
    }

    private ExhilaratingElocutionEffect(ExhilaratingElocutionEffect effect) {
        super((OneShotEffect)effect);
    }

    public ExhilaratingElocutionEffect copy() {
        return new ExhilaratingElocutionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        permanent.addCounters(CounterType.P1P1.createInstance(2), source.getControllerId(), source, game);
        FilterCreaturePermanent filterPermanent = new FilterCreaturePermanent();
        filterPermanent.add(Predicates.not((Predicate)new MageObjectReferencePredicate(new MageObjectReference((MageObject)permanent, game))));
        game.addEffect((ContinuousEffect)new BoostControlledEffect(1, 1, Duration.EndOfTurn, (FilterPermanent)filterPermanent), source);
        return true;
    }
}

