/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.common.TurnFaceUpAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.abilities.keyword.MorphAbility;
import mage.cards.Card;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class ExiledDoomsayerEffect
extends CostModificationEffectImpl {
    ExiledDoomsayerEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral, CostModificationType.INCREASE_COST);
        this.staticText = "All morph costs cost {2} more. <i>(This doesn't affect the cost to cast creature spells face down.)</i>";
    }

    private ExiledDoomsayerEffect(ExiledDoomsayerEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.increaseCost((Ability)abilityToModify, (int)2);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (!(abilityToModify instanceof TurnFaceUpAbility)) {
            return false;
        }
        Permanent permanent = game.getPermanent(abilityToModify.getSourceId());
        if (permanent == null) {
            return false;
        }
        Card card = game.getCard(permanent.getId());
        if (card == null) {
            return false;
        }
        for (Ability ability : card.getAbilities(game)) {
            if (!(ability instanceof MorphAbility)) continue;
            return true;
        }
        return false;
    }

    public ExiledDoomsayerEffect copy() {
        return new ExiledDoomsayerEffect(this);
    }
}

