/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.common.LookLibraryControllerEffect;
import mage.abilities.effects.common.counter.ProliferateEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.PutCards;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class ExpandTheSphereEffect
extends LookLibraryControllerEffect {
    public ExpandTheSphereEffect() {
        super(6);
        this.staticText = "Look at the top six cards of your library. Put up to two land cards from among them onto the battlefield tapped and the rest on the bottom of your library in a random order. If you put fewer than two lands onto the battlefield this way, proliferate a number of times equal to the difference. <i>(Choose any number of permanents and/or players, then give each another counter of each kind already there.)</i>";
    }

    private ExpandTheSphereEffect(ExpandTheSphereEffect effect) {
        super((LookLibraryControllerEffect)effect);
    }

    protected boolean actionWithLookedCards(Game game, Ability source, Player player, Cards cards) {
        TargetCard target = new TargetCard(0, 2, Zone.LIBRARY, (FilterCard)StaticFilters.FILTER_CARD_LAND);
        target.withChooseHint("to put " + PutCards.BATTLEFIELD_TAPPED.getMessage(false, false));
        CardsImpl pickedCards = !player.chooseTarget(PutCards.BATTLEFIELD_TAPPED.getOutcome(), cards, target, source, game) ? new CardsImpl() : new CardsImpl((Collection)target.getTargets());
        cards.removeAll((Collection)pickedCards);
        boolean result = PutCards.BATTLEFIELD_TAPPED.moveCards(player, (Cards)pickedCards, source, game);
        result |= PutCards.BOTTOM_RANDOM.moveCards(player, cards, source, game);
        if (pickedCards.size() < 2) {
            new ProliferateEffect(true).apply(game, source);
        }
        if (pickedCards.size() < 1) {
            new ProliferateEffect(true).apply(game, source);
        }
        return result;
    }

    public ExpandTheSphereEffect copy() {
        return new ExpandTheSphereEffect(this);
    }
}

