/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.util.CardUtil;

class ExpeditedInheritanceMayPlayEffect
extends AsThoughEffectImpl {
    private final UUID cardOwnerId;
    private int triggeredOnTurn = 0;

    ExpeditedInheritanceMayPlayEffect(UUID playerId) {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.Custom, Outcome.Benefit);
        this.staticText = "Until the end of your next turn, you may play this card.";
        this.cardOwnerId = playerId;
    }

    private ExpeditedInheritanceMayPlayEffect(ExpeditedInheritanceMayPlayEffect effect) {
        super((AsThoughEffectImpl)effect);
        this.triggeredOnTurn = effect.triggeredOnTurn;
        this.cardOwnerId = effect.cardOwnerId;
    }

    public ExpeditedInheritanceMayPlayEffect copy() {
        return new ExpeditedInheritanceMayPlayEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.triggeredOnTurn = game.getTurnNum();
    }

    public boolean isInactive(Ability source, Game game) {
        return this.triggeredOnTurn != game.getTurnNum() && game.getPhase().getStep().getType() == PhaseStep.END_TURN && game.isActivePlayer(this.cardOwnerId);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        UUID objectIdToCast = CardUtil.getMainCardId((Game)game, (UUID)sourceId);
        return this.cardOwnerId != null && this.cardOwnerId.equals(affectedControllerId) && this.getTargetPointer().getTargets(game, source).contains(objectIdToCast);
    }
}

