/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyAllEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class ExpelTheInterlopersEffect
extends OneShotEffect {
    ExpelTheInterlopersEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "choose a number between 0 and 10. Destroy all creatures with power greater than or equal to the chosen number";
    }

    private ExpelTheInterlopersEffect(ExpelTheInterlopersEffect effect) {
        super((OneShotEffect)effect);
    }

    public ExpelTheInterlopersEffect copy() {
        return new ExpelTheInterlopersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int number = player.getAmount(0, 10, "Choose a number between 0 and 10", source, game);
        game.informPlayers(player.getLogName() + " has chosen the number " + number + "." + CardUtil.getSourceLogName((Game)game, (Ability)source));
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add((Predicate)new PowerPredicate(ComparisonType.OR_GREATER, number));
        return new DestroyAllEffect((FilterPermanent)filter).apply(game, source);
    }
}

