/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ExperimentKrajEffect
extends ContinuousEffectImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("each other creature with a +1/+1 counter on it");

    public ExperimentKrajEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "{this} has all activated abilities of each other creature with a +1/+1 counter on it";
    }

    private ExperimentKrajEffect(ExperimentKrajEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent perm = game.getPermanent(source.getSourceId());
        if (perm != null) {
            for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
                for (Ability ability : creature.getAbilities()) {
                    if (!ability.isActivatedAbility()) continue;
                    perm.addAbility(ability, source.getSourceId(), game, true);
                }
            }
        }
        return true;
    }

    public ExperimentKrajEffect copy() {
        return new ExperimentKrajEffect(this);
    }

    static {
        filter.add((Predicate)CounterType.P1P1.getPredicate());
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

