/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ExplorersScopeEffect
extends OneShotEffect {
    ExplorersScopeEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "look at the top card of your library. If it's a land card, you may put it onto the battlefield tapped";
    }

    private ExplorersScopeEffect(ExplorersScopeEffect effect) {
        super((OneShotEffect)effect);
    }

    public ExplorersScopeEffect copy() {
        return new ExplorersScopeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        if (card != null) {
            String message;
            CardsImpl cards = new CardsImpl(card);
            controller.lookAtCards(sourceObject.getIdName(), (Cards)cards, game);
            if (card.isLand(game) && controller.chooseUse(Outcome.PutLandInPlay, message = "Put " + card.getLogName() + " onto the battlefield tapped?", source, game)) {
                controller.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
            }
        }
        return true;
    }
}

