/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class ExplosionEffect
extends OneShotEffect {
    ExplosionEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals X damage to any target. Target player draws X cards.";
    }

    private ExplosionEffect(ExplosionEffect effect) {
        super((OneShotEffect)effect);
    }

    public ExplosionEffect copy() {
        return new ExplosionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        DamageTargetEffect effect = new DamageTargetEffect((DynamicValue)StaticValue.get((int)xValue), true, "", true);
        effect.setTargetPointer((TargetPointer)new FixedTarget(source.getFirstTarget(), game));
        effect.apply(game, source);
        Player player = game.getPlayer(((Target)source.getTargets().get(1)).getFirstTarget());
        if (player != null) {
            player.drawCards(xValue, source, game);
        }
        return true;
    }
}

