/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapVariableTargetCost;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class ExplosiveSingularityCostReductionEffect
extends CostModificationEffectImpl {
    ExplosiveSingularityCostReductionEffect() {
        super(Duration.WhileOnStack, Outcome.Benefit, CostModificationType.REDUCE_COST);
    }

    private ExplosiveSingularityCostReductionEffect(ExplosiveSingularityCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        SpellAbility spellAbility = (SpellAbility)abilityToModify;
        for (Cost cost : spellAbility.getCosts()) {
            if (!(cost instanceof TapVariableTargetCost)) continue;
            if (game.inCheckPlayableState()) {
                int reduction = ((TapVariableTargetCost)cost).getMaxValue(source, game);
                CardUtil.adjustCost((SpellAbility)spellAbility, (int)reduction);
                break;
            }
            int reduction = ((TapVariableTargetCost)cost).getAmount();
            CardUtil.adjustCost((SpellAbility)spellAbility, (int)reduction);
            break;
        }
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify instanceof SpellAbility && abilityToModify.getSourceId().equals(source.getSourceId());
    }

    public ExplosiveSingularityCostReductionEffect copy() {
        return new ExplosiveSingularityCostReductionEffect(this);
    }
}

