/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class ExponentialGrowthEffect
extends OneShotEffect {
    ExponentialGrowthEffect() {
        super(Outcome.Benefit);
        this.staticText = "until end of turn, double target creature's power X times";
    }

    private ExponentialGrowthEffect(ExponentialGrowthEffect effect) {
        super((OneShotEffect)effect);
    }

    public ExponentialGrowthEffect copy() {
        return new ExponentialGrowthEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        int multiplier = 1;
        for (int i = 0; i < xValue; ++i) {
            multiplier = CardUtil.overflowMultiply((int)multiplier, (int)2);
        }
        multiplier = CardUtil.overflowDec((int)multiplier, (int)1);
        game.addEffect((ContinuousEffect)new BoostTargetEffect(CardUtil.overflowMultiply((int)multiplier, (int)permanent.getPower().getValue()), 0, Duration.EndOfTurn), source);
        return true;
    }
}

