/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValueParityPredicate;
import mage.game.Game;
import mage.players.Player;

class ExtinctionEventEffect
extends OneShotEffect {
    private static final FilterPermanent evenFilter = new FilterCreaturePermanent();
    private static final FilterPermanent oddFilter = new FilterCreaturePermanent();

    ExtinctionEventEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose odd or even. Exile each creature with mana value of the chosen quality. <i>(Zero is even.)</i>";
    }

    private ExtinctionEventEffect(ExtinctionEventEffect effect) {
        super((OneShotEffect)effect);
    }

    public ExtinctionEventEffect copy() {
        return new ExtinctionEventEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        FilterPermanent filter = player.chooseUse(this.outcome, "Odd or even?", null, "Odd", "Even", source, game) ? oddFilter : evenFilter;
        return player.moveCards(game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game).stream().collect(Collectors.toSet()), Zone.EXILED, source, game);
    }

    static {
        evenFilter.add((Predicate)ManaValueParityPredicate.EVEN);
        oddFilter.add((Predicate)ManaValueParityPredicate.ODD);
    }
}

