/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.CantAttackBlockTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class ExtractionSpecialistEffect
extends OneShotEffect {
    ExtractionSpecialistEffect() {
        super(Outcome.Benefit);
        this.staticText = "return target creature card with mana value 2 or less from your graveyard to the battlefield. That creature can't attack or block for as long as you control {this}";
    }

    private ExtractionSpecialistEffect(ExtractionSpecialistEffect effect) {
        super((OneShotEffect)effect);
    }

    public ExtractionSpecialistEffect copy() {
        return new ExtractionSpecialistEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent != null && source.getSourcePermanentIfItStillExists(game) != null && source.isControlledBy(game.getControllerId(source.getSourceId()))) {
            game.addEffect(new CantAttackBlockTargetEffect(Duration.WhileControlled).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        }
        return true;
    }
}

