/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class ExtraplanarLensImprintEffect
extends OneShotEffect {
    ExtraplanarLensImprintEffect() {
        super(Outcome.Neutral);
        this.staticText = "you may exile target land you control";
    }

    private ExtraplanarLensImprintEffect(ExtraplanarLensImprintEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent extraplanarLens = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null) {
            Permanent targetLand = game.getPermanent(source.getFirstTarget());
            if (targetLand != null) {
                targetLand.moveToExile(null, extraplanarLens.getName() + " (Imprint)", source, game);
                extraplanarLens.imprint(targetLand.getId(), game);
                extraplanarLens.addInfo("imprint", CardUtil.addToolTipMarkTags((String)("[Imprinted card - " + targetLand.getLogName() + ']')), game);
            }
            return true;
        }
        return false;
    }

    public ExtraplanarLensImprintEffect copy() {
        return new ExtraplanarLensImprintEffect(this);
    }
}

