/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.effects.Effect;
import mage.abilities.effects.mana.AddManaOfAnyTypeProducedEffect;
import mage.abilities.mana.TriggeredManaAbility;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ManaEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ExtraplanarLensTriggeredAbility
extends TriggeredManaAbility {
    public ExtraplanarLensTriggeredAbility() {
        super(Zone.BATTLEFIELD, new AddManaOfAnyTypeProducedEffect().setText("its controller adds one mana of any type that land produced"));
        this.setTriggerPhrase("Whenever a land with the same name as the exiled card is tapped for mana, ");
    }

    private ExtraplanarLensTriggeredAbility(ExtraplanarLensTriggeredAbility ability) {
        super((TriggeredManaAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Card imprinted;
        Permanent landTappedForMana = ((TappedForManaEvent)event).getPermanent();
        Permanent extraplanarLens = game.getPermanent(this.getSourceId());
        if (extraplanarLens != null && landTappedForMana != null && !extraplanarLens.getImprinted().isEmpty() && (imprinted = game.getCard((UUID)extraplanarLens.getImprinted().get(0))) != null && game.getState().getZone(imprinted.getId()) == Zone.EXILED && landTappedForMana.getName().equals(imprinted.getName()) && landTappedForMana.isLand(game)) {
            ManaEvent mEvent = (ManaEvent)event;
            for (Effect effect : this.getEffects()) {
                effect.setValue("mana", (Object)mEvent.getMana());
                effect.setValue("tappedPermanent", (Object)landTappedForMana);
            }
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(landTappedForMana.getId()));
            return true;
        }
        return false;
    }

    public ExtraplanarLensTriggeredAbility copy() {
        return new ExtraplanarLensTriggeredAbility(this);
    }
}

