/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeSourceUnlessPaysEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ExtravagantSpiritEffect
extends OneShotEffect {
    ExtravagantSpiritEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "sacrifice {this} unless you pay {1} for each card in your hand";
    }

    private ExtravagantSpiritEffect(ExtravagantSpiritEffect effect) {
        super((OneShotEffect)effect);
    }

    public ExtravagantSpiritEffect copy() {
        return new ExtravagantSpiritEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        return new SacrificeSourceUnlessPaysEffect((Cost)new GenericManaCost(player.getHand().size())).apply(game, source);
    }
}

